---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-asmc SMS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/asmc/asmc.c` 1531-1553行目 - asmc_sms_task()関数の実装
- E-02: `sys/dev/asmc/asmc.c` 1552行目 - devctl_notify()呼び出し
- E-03: `sys/dev/asmc/asmc.c` 1537-1549行目 - switch文による割り込みタイプ変換
- E-04: `sys/dev/asmc/asmc.c` 1551行目 - notify_buf生成（" notify=0x%x"）
- E-05: `sys/dev/asmc/asmcvar.h` 107行目 - ASMC_SMS_INTFF (0x60) 定義
- E-06: `sys/dev/asmc/asmcvar.h` 108行目 - ASMC_SMS_INTHA (0x6f) 定義
- E-07: `sys/dev/asmc/asmcvar.h` 109行目 - ASMC_SMS_INTSH (0x80) 定義
- E-08: `sys/dev/asmc/asmc.c` 85行目 - asmc_sms_intrfast()プロトタイプ
- E-09: `sys/dev/asmc/asmc.c` 87行目 - asmc_sms_task()プロトタイプ
- E-10: `sys/dev/asmc/asmc.c` 758-759行目 - タスクキューのコメント（PI_REALTIME優先度）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("ACPI", "asmc", "SMS", notify)として通知される | E-02 | ○ |
| C-02 | ASMC_SMS_INTFF(0x60)はFree Fall割り込み | E-05 | ○ |
| C-03 | ASMC_SMS_INTHA(0x6f)はHigh Acceleration割り込み | E-06 | ○ |
| C-04 | ASMC_SMS_INTSH(0x80)はShock割り込み | E-07 | ○ |
| C-05 | Free Fall -> type=2, High Acceleration -> type=1, Shock -> type=0 | E-03 | ○ |
| C-06 | 不明な割り込みはtype=255にマッピングされる | E-03 | ○ |
| C-07 | asmc_sms_task()は1531行目に定義されている | E-01 | ○ |
| C-08 | devctl_notifyは1552行目で呼び出される | E-02 | ○ |
| C-09 | notify_bufのフォーマットは" notify=0x%x"（先頭スペースあり） | E-04 | ○ |
| C-10 | タスクキュー経由で遅延実行される | E-09, E-10 | ○ |
| C-11 | PI_REALTIME優先度でタスクキューに投入される | E-10 | ○ |
| C-12 | asmc_sms_intrfast()が割り込みハンドラである | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの直接的な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] SMS割り込みタイプのマッピング（INTFF->2, INTHA->1, INTSH->0）が正確か確認
- [ ] notify_bufの先頭スペースがdevd(8)側で正しく処理されるか確認
